<?php $__env->startSection('title'); ?>
Medicines <?php if(isset($medicine)): ?> Edit <?php else: ?> Add <?php endif; ?>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('sideMenuTitle'); ?>
Medicines <?php if(isset($medicine)): ?> Edit <?php else: ?> Add <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('pageTitle'); ?>
<a href="<?php echo e(url('product/list')); ?>"><i class="fa fa-dashboard"></i>Medicine List</a>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('bodyContent'); ?>

<section class="content">
  <?php if(Session::has('message')): ?>
  <div class="alert alert-success alert-dismissible">
    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
    <h4><i class="icon fa fa-check"></i>
      <?php echo e(Session::get('message')); ?></h4>
  </div>
  <?php endif; ?>

  <?php if(Session::has('error')): ?>
  <div class="alert alert-danger alert-warning alert-dismissible">
    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
    <h4><i class="icon fa fa-check"></i>
      <?php echo e(Session::get('error')); ?></h4>
  </div>
  <?php endif; ?>

  <?php if($errors->any()): ?>
  <div class="alert alert-danger alert-warning alert-dismissible">
    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
    <ul>
      <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <li><?php echo e($error); ?></li>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
  </div>
  <?php endif; ?>
  <div class="row">
    <!-- left column -->
    <div class="col-lg-12 centerDiv">
      <!-- general form elements -->
      <div class="box box-primary">
        <div class="box-header with-border">
          <h3 class="box-title"></h3>
        </div>
        <a class="btn btn-app bg-blue" href="<?php echo e(url('category/add')); ?>">
          <i class="fa fa-plus"></i> Add Category
        </a>

        <a class="btn btn-app bg-blue" href="<?php echo e(url('groups/add')); ?>">
          <i class="fa fa-plus"></i> Add Medicine Groups
        </a>

        <a class="btn btn-app bg-blue" href="<?php echo e(url('genericnames/add')); ?>">
          <i class="fa fa-plus"></i> Add Generic Names
        </a>

        <a class="btn btn-app bg-blue" href="<?php echo e(url('supplier/add')); ?>">
          <i class="fa fa-plus"></i> Add Supplier
        </a>
        <!-- /.box-header -->
        <!-- form start -->
        <?php if(!isset($medicine)): ?>
        <?php echo Form::open(['url' => 'product/add', 'method' => 'post', 'name' => 'medForm', 'enctype' => 'multipart/form-data', 'role' => 'form']); ?>

        <?php endif; ?>
        <?php if(isset($medicine)): ?>
        <?php echo Form::open(['url' => 'product/update', 'method' => 'post','name' => 'medForm', 'enctype' => 'multipart/form-data', 'role' => 'form']); ?>

        <input type="hidden" class="form-control" name="id" value="<?php echo e($medicine->id); ?>">
        <input type="hidden" class="form-control" name="type" value="edit">

        <?php endif; ?>

        <div class="box-body">
          <p>Please add category, group, generic name, company name before adding medicine.</p>

          <div class="form-group">
            <label>Select Category *</label>
            <select class="form-control select2 category" name="category">
              <option value="" selected>Select Category</option>
              <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($category->id); ?>" <?php echo e((isset($medicine) ? ($medicine->category_id == $category->id ? 'selected="selected"' : '') : ($loop->first ? 'selected="selected"' : '' ) )); ?>><?php echo e($category->name); ?></option>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
          </div>

          <div class="form-group">
            <label for="exampleInputEmail1">Select Medicine Group *</label>
            <select class="form-control medicine_group" name="groupName" required>
              <?php $__currentLoopData = $groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($group->id); ?>" <?php echo e((isset($medicine) ? ($medicine->group_id == $group->id ? 'selected="selected"' : '') : ($loop->first ? 'selected="selected"' : '' ) )); ?> ><?php echo e($group->name); ?></option>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
          </div>

          <div class="form-group">
            <label for="exampleInputEmail1">Medicine Name *</label>
            <input type="text" class="form-control" name="name" placeholder="Name" value="<?php echo e(isset($medicine) ? $medicine->name:old('name')); ?>" required>
          </div>
          <div class="form-group">
            <label for="exampleInputEmail1">Purchase Price(<?php echo e(($settings) ? $settings->currency_symbol : 0); ?>) Per Piece *</label>
            <input type="text" class="form-control" name="purchasePrice" placeholder="Purchase Price" value="<?php echo e(isset($medicine) ? $medicine->purchasePrice :old('purchasePrice')); ?>" required>
          </div>
          <div class="form-group">
            <label for="exampleInputEmail1">Selling Price(<?php echo e(($settings) ? $settings->currency_symbol : 0); ?>) Per Piece *</label>
            <input type="text" class="form-control" name="sellingPrice" placeholder="Selling Price" value="<?php echo e(isset($medicine) ? $medicine->sellingPrice :old('sellingPrice')); ?>" required>
          </div>

          <div class="form-group">
            <label for="exampleInputEmail1">Number of Boxes In Stock *</label>
            <input type="number" class="form-control" name="storeBox" placeholder="Store Box" value="<?php echo e(isset($medicine) ? $medicine->storeBox :old('storeBox')); ?>" <?php echo isset($medicine) ? 'readonly' : '' ?> required>
          </div>

          <div class="form-group">
            <label for="exampleInputEmail1">Items Each Box *</label>
            <input type="number" class="form-control" name="itemsNumber" placeholder="Items Each Box" value="<?php echo e(isset($medicine) ? $medicine->itemsNumber :old('itemsNumber')); ?>" <?php echo isset($medicine) ? 'readonly' : '' ?> required>
          </div>

          <div class="form-group">
            <label for="exampleInputEmail1">Generic Name *</label>
            <select class="form-control" name="genericName" required>
              <?php if(!empty($genericNames)): ?>
              <?php $__currentLoopData = $genericNames; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <option value="<?php echo e($name->id); ?>"  <?php echo e((isset($medicine) ? ($medicine->generic_id == $name->id ? 'selected="selected"' : '') : ($loop->first ? 'selected="selected"' : '' ) )); ?>  ><?php echo e($name->name); ?></option>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              <?php endif; ?>

            </select>
          </div>

          <div class="form-group">
            <label for="exampleInputEmail1">Supplier/ Company Name *</label>
            <select class="form-control" name="companyName" required>
              <?php if(!empty($companyNames)): ?>
                <?php $__currentLoopData = $companyNames; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($name->id); ?>" <?php echo e((isset($medicine) ? ($medicine->supplier_id == $name->id ? 'selected="selected"' : '') : ($loop->first ? 'selected="selected"' : '' ) )); ?> ><?php echo e($name->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              <?php endif; ?>
            </select>
          </div>

          <div class="form-group">
            <label for="exampleInputEmail1">Medicine Description (Optional)</label>
            <textarea class="form-control" rows="3" name="description" placeholder="Description"><?php echo e(isset($medicine) ? $medicine->description:old('description')); ?></textarea>
          </div>

          <div class="form-group">
            <label>Medicine Expire Date *</label>

            <div class="input-group date">
              <div class="input-group-addon">
                <i class="fa fa-calendar"></i>
              </div>
              <input type="text" class="form-control pull-right" id="datepicker" name="expireDate" data-date-format="yyyy-mm-dd" value="<?php echo e(isset($medicine) ? $medicine->expireDate :old('expiredDate')); ?>" required>
            </div>
            <!-- /.input group -->
          </div>

          <div class="form-group">
            <label>Select Publish Status *</label>
            <select class="form-control" name="status" required>
                <?php $__currentLoopData = $publish; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pub): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($pub->id); ?>" <?php echo e((isset($medicine) ? ($medicine->status == $pub->id ? 'selected="selected"' : '') : ($loop->first ? 'selected="selected"' : '' ) )); ?> ><?php echo e($pub->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
            </select>
          </div>
          <div class="form-group">
            <label for="exampleInputFile">File input *</label>
            <input type="file" id="exampleInputFile" name="image" <?php if(!isset($medicine)): ?> required <?php endif; ?>>

            <p class="help-block"></p>
          </div>

        </div>
        <!-- /.box-body -->

        <div class="box-footer">
          <button type="submit" class="btn btn-primary">Submit</button>
        </div>
        <?php echo Form::close(); ?>

        
      </div>
      <!-- /.box -->


    </div>
  </div>
</section>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\pharmastore\resources\views/admin/Product/add.blade.php ENDPATH**/ ?>