<!DOCTYPE html>
<html lang="zxx">

<head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Pharmastore</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <!-- Use Minified Plugins Version For Fast Page Load -->
    <link rel="stylesheet" type="text/css" media="screen" href="<?php echo e(asset('assets/frontend/css/plugins.css')); ?>" />
    <link rel="stylesheet" type="text/css" media="screen" href="<?php echo e(asset('assets/frontend/css/main.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('view_css/frontend/common.css')); ?>">
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(asset('assets/frontend/image/favicon.ico')); ?>">
    <script src="<?php echo e(asset('assets/frontend/js/plugins.js')); ?>"></script>
    <script src="https://js.stripe.com/v3/"></script>
</head>

<body>
    <div class="site-wrapper" id="top">

        <?php echo $__env->make('layouts.frontend.include.main_header_nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php echo $__env->make('layouts.frontend.include.site_mobile_menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php echo $__env->make('layouts.frontend.include.sticky_menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


        <?php echo $__env->yieldContent('content'); ?>

        <!--=================================
        Footer
        ===================================== -->
    </div>
    <!--=================================
    Brands Slider
    ===================================== -->
    <?php echo $__env->make('layouts.frontend.include.brand_slider', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!--=================================
    Footer Area
    ===================================== -->

    <?php echo $__env->make('layouts.frontend.include.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Use Minified Plugins Version For Fast Page Load -->

    <script src="<?php echo e(asset('assets/frontend/js/ajax-mail.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/frontend/js/custom.js')); ?>"></script>
    <?php echo $__env->yieldContent('scripts'); ?>
    <script src="<?php echo e(asset('view_js/frontend/app.js')); ?>"></script>
    <script>
        "use strict";

        //GLOBAL 
        var currencySymbol = '<?php echo e(isset($settings) ? $settings->currency_symbol ?? "Currency Not Set " : "Currency Not Set "); ?>';
        var cartUrl = "<?php echo e(route('cart')); ?>";
        var checkoutUrl = "<?php echo e(route('checkout')); ?>";
        var storeCartUrl = '<?php echo e(route("storecart")); ?>';

        var cart;
        <?php if(session('cart_data')): ?>
        cart = <?php echo json_encode(session('cart_data'), 15, 512) ?>;
        <?php else: ?>
        cart = [];
        <?php endif; ?>
    </script>

</body>

</html><?php /**PATH D:\xampp\htdocs\pharmastore\resources\views/layouts/frontend/app.blade.php ENDPATH**/ ?>