<?php $__env->startSection('title'); ?>
	Medicine List
<?php $__env->stopSection(); ?>	


<?php $__env->startSection('sideMenuTitle'); ?>
  Medicine List
<?php $__env->stopSection(); ?>

<?php $__env->startSection('pageTitle'); ?>
<a href="<?php echo e(url('product/add')); ?>"><i class="fa fa-dashboard"></i>Medicine Add</a>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('bodyContent'); ?>

 <section class="content">
 	<?php if(Session::has('message')): ?>
 	<div class="alert alert-success alert-dismissible">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                <h4><i class="icon fa fa-check"></i>
                <?php echo e(Session::get('message')); ?></h4>
     </div>
     <?php endif; ?>
    
      <?php if($errors->any()): ?>
		    <div class="alert alert-danger alert-warning alert-dismissible">
		      <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
		        <ul>
		            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
		                <li><?php echo e($error); ?></li>
		            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		        </ul>
		    </div>
		<?php endif; ?>

		<div class="row">
        <div class="col-xs-12">
          <div class="box">
            <div class="box-header">
              <h3 class="box-title">Now showing <?php echo e($listData->count() * $listData->currentPage()); ?> out of <?php echo e($listData->total()); ?> Medicines</h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              <table id="example2" class="table table-bordered table-hover">
                <thead>
                <tr>
                  <th>ID</th>	
                  <th>Name</th>
                  <th>Image</th>
                  <th>Generic Name</th>
                  <th>Purchase Price(<?php echo e(($settings) ? $settings->currency_symbol : 0); ?>)</th>
                  <th>Selling Price(<?php echo e(($settings) ? $settings->currency_symbol : 0); ?>)</th>
                  <th>Total Item</th>
                  <th>Status</th>
                  <th>Action</th>
                </tr>
                </thead>
                <tbody>
                	<?php $i = 1; ?>
                	<?php $__currentLoopData = $listData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
	                <tr>
	                 <td><?php echo e($i++); ?></td>	
                    <td><?php echo e($val->name); ?></td>
                    <td><img src="<?php echo e(asset($val->image)); ?>" width="50" height="50" alt="no image"></td>
                    <td><?php echo e(isset($val->generic->name) ? $val->generic->name : ''); ?></td>
                    <td><?php echo e($val->purchasePrice); ?></td>
                    <td><?php echo e($val->sellingPrice); ?></td>
                    <td><?php echo e($val->totalPurchedItem); ?></td>
	                  <td><?php echo e($val->status == 1 ? "Published" : "Unpublished"); ?></td>
	                  <td>
	                  	 <a class="btn btn-app  bg-blue" href="<?php echo e(url('product/edit/'.$val->id)); ?>">
    			                <i class="fa fa-edit"></i> Edit
    			             </a>

                        <a class="btn btn-app  bg-blue" href="<?php echo e(url('product/restock/'.$val->id)); ?>">
                          <i class="fa fa-plus"></i> Restock
                       </a>

    			             <a class="btn btn-app bg-red" href="#" onclick="delete_item('<?php echo e(url('product/delete/'.$val->id)); ?>');">
    			                <i class="fa fa-trash"></i> Delete
    			             </a>

                       <a class="btn btn-app" href="<?php echo e(url('product/details/'.$val->id)); ?>">
                          <i class="fa fa-book"></i> Details
                       </a>

    			             <?php if($val->status == 2): ?>
    			             <a class="btn btn-app bg-green" href="<?php echo e(url('product/publishStatus/publish/'.$val->id)); ?>">
    			                <i class="fa fa-file-o"></i>Publish?
    			             </a>
    			             <?php endif; ?>

    			             <?php if($val->status == 1): ?>
    			             <a class="btn btn-app bg-yellow" href="<?php echo e(url('product/publishStatus/unpublish/'.$val->id)); ?>">
    			                <i class="fa fa-file-archive-o"></i> Unpublish?
    			             </a>
			             <?php endif; ?>


			          </td>
	                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </tbody>
               
              </table>

              <?php echo e($listData->links()); ?>

            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->
         
          <!-- /.box -->
        </div>
        <!-- /.col -->
      </div>

</section>		         
	
<?php $__env->stopSection(); ?>			
<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\pharmastore\resources\views/admin/Product/listmanage.blade.php ENDPATH**/ ?>