<?php $__env->startSection('content'); ?>
<link rel="stylesheet" href="<?php echo e(asset('view_css/frontend/checkout.css')); ?>">
<section class="breadcrumb-section">
    <h2 class="sr-only">Site Breadcrumb</h2>
    <div class="container">
        <div class="breadcrumb-contents">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('main_home')); ?>">Home</a></li>
                    <li class="breadcrumb-item active">Checkout</li>
                </ol>
            </nav>
        </div>
    </div>
</section>

<!-- Cart Page Start -->
<main id="content" class="page-section inner-page-sec-padding-bottom space-db--20">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <!-- Checkout Form s-->
                <div class="checkout-form">
                    <div class="row row-40">
                        <div class="col-12">
                            <?php if(auth()->guard()->guest()): ?>
                           
                            
                            <div class="checkout-slidedown-box" id="quick-login">
                                <form action="<?php echo e(route('customer.signin.submit')); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <div class="quick-login-form">
                                        <p>If you have shopped with us before, please enter your details in the
                                            boxes below. If you are a new
                                            customer
                                            please
                                            proceed to the Billing & Shipping section.</p>
                                        <div class="form-group">
                                            <label for="quick-user">Email *</label>
                                            <input type="email" placeholder="" name="email" id="quick-user">
                                        </div>
                                        <div class="form-group">
                                            <label for="quick-pass">Password *</label>
                                            <input type="password" name="password" placeholder="" id="quick-pass">
                                        </div>
                                        <div class="form-group">
                                            <div class="d-flex align-items-center flex-wrap">
                                                
                                                <input type="hidden" name="checkout_login" value="checkout">
                                                <button type="submit" class="btn btn-outlined   mr-3">Login</button>
                                                <div class="d-inline-flex align-items-center">
                                                    <input type="checkbox" id="accept_terms" class="mb-0 mr-1">
                                                    <label for="accept_terms" class="mb-0">I’ve read and accept
                                                        the terms &amp; conditions</label>
                                                </div>
                                            </div>
                                            <p><a href="javascript:" class="pass-lost mt-3">Lost your
                                                    password?</a></p>
                                        </div>
                                    </div>
                                </form>
                            </div>
                            <?php endif; ?>

                        </div>
                        <form action="<?php echo e(route('orderprocess')); ?>" method="post" id="payment-form">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <?php if($errors->has('isagree')): ?>
                                <div class="col-12">
                                    <div class="alert alert-danger">
                                        <div class="alert alert-danger" role="alert">
                                            <?php echo e($errors->first('isagree')); ?>

                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <div class="col-lg-7 mb--20">
                                <!-- Billing Address -->
                                <div id="billing-form" class="mb-40">
                                    <h4 class="checkout-title">Checkout</h4>
                                    <div class="row">
                                        <div class="col-md-6 col-12 mb--20">
                                            <label>First Name* </label>
                                            <input type="text" name="firstname" value="<?php echo e(old('firstname') ? old('firstname'): (Auth::check()? Auth::user()->firstname :'')); ?>" placeholder="First Name">
                                            <?php if($errors->has('firstname')): ?>
                                            <span class="color-ff00"><?php echo e($errors->first('firstname')); ?></span>
                                            <?php endif; ?>
                                        </div>
                                        <div class="col-md-6 col-12 mb--20">
                                            <label>Last Name*</label>
                                            <input type="text" name="lastname" value="<?php echo e(old('lastname') ? old('lastname'): (Auth::check()? Auth::user()->lastname :'')); ?>" placeholder="Last Name">
                                            <?php if($errors->has('lastname')): ?>
                                            <span class="color-ff00"><?php echo e($errors->first('lastname')); ?></span>
                                            <?php endif; ?>
                                        </div>
                                        
                                        <div class="col-12 col-12 mb--20">
                                            <label>Country*</label>
                                            <select class="nice-select" name="country" >
                                                <option>Bangladesh</option>
                                                <option>China</option>
                                                <option>country</option>
                                                <option>India</option>
                                                <option>Japan</option>
                                            </select>
                                            <?php if($errors->has('country')): ?>
                                            <span class="color-ff00"><?php echo e($errors->first('country')); ?></span>
                                            <?php endif; ?>
                                        </div>
                                        <div class="col-md-6 col-12 mb--20">
                                            <label>Email Address*</label>
                                            <input type="email" name="email" value="<?php echo e(old('email') ? old('email'): (Auth::check()? Auth::user()->email :'')); ?>" placeholder="Email Address">
                                            <?php if($errors->has('email')): ?>
                                            <span class="color-ff00"><?php echo e($errors->first('email')); ?></span>
                                            <?php endif; ?>
                                        </div>
                                        <div class="col-md-6 col-12 mb--20">
                                            <label>Phone no*</label>
                                            <input type="text" name="phone" value="<?php echo e(old('phone') ? old('phone'): (Auth::check()? Auth::user()->phone :'')); ?>" placeholder="Phone number">
                                            <?php if($errors->has('phone')): ?>
                                            <span class="color-ff00"><?php echo e($errors->first('phone')); ?></span>
                                            <?php endif; ?>
                                        </div>
                                        <div class="col-12 mb--20">
                                            <label>Address*</label>
                                            <input type="text" name="address" value="<?php echo e(old('address') ? old('address'): (Auth::check()? Auth::user()->address :'')); ?>"  placeholder="Address">
                                            
                                            <?php if($errors->has('address')): ?>
                                            <span class="color-ff00"><?php echo e($errors->first('address')); ?></span>
                                            <?php endif; ?>
                                        </div>
                                        <div class="col-md-6 col-12 mb--20">
                                            <label>Town/City*</label>
                                            <input type="text" name="city" value="<?php echo e(old('city') ? old('city'): (Auth::check()? Auth::user()->city :'')); ?>" placeholder="Town/City">
                                            <?php if($errors->has('city')): ?>
                                            <span class="color-ff00"><?php echo e($errors->first('city')); ?></span>
                                            <?php endif; ?>
                                        </div>
                                        <div class="col-md-6 col-12 mb--20">
                                            <label>Zip Code*</label>
                                            <input type="text" name="postcode" value="<?php echo e(old('postcode') ? old('postcode'): (Auth::check()? Auth::user()->postcode :'')); ?>" placeholder="Zip Code">
                                            <?php if($errors->has('postcode')): ?>
                                            <span class="color-ff00"><?php echo e($errors->first('postcode')); ?></span>
                                            <?php endif; ?>
                                        </div>
                                        
                                        
                                        
                                        
                                    </div>
                                </div>
                                <!-- Shipping Address -->
                                <div id="shipping-form" class="mb--40">
                                    <h4 class="checkout-title">Shipping Address</h4>
                                    <div class="row">
                                        <div class="col-md-6 col-12 mb--20">
                                            <label>First Name*</label>
                                            <input type="text" placeholder="First Name">
                                        </div>
                                        <div class="col-md-6 col-12 mb--20">
                                            <label>Last Name*</label>
                                            <input type="text" placeholder="Last Name">
                                        </div>
                                        <div class="col-md-6 col-12 mb--20">
                                            <label>Email Address*</label>
                                            <input type="email" placeholder="Email Address">
                                        </div>
                                        <div class="col-md-6 col-12 mb--20">
                                            <label>Phone no*</label>
                                            <input type="text" placeholder="Phone number">
                                        </div>
                                        <div class="col-12 mb--20">
                                            <label>Company Name</label>
                                            <input type="text" placeholder="Company Name">
                                        </div>
                                        <div class="col-12 mb--20">
                                            <label>Address*</label>
                                            <input type="text" placeholder="Address line 1">
                                            <input type="text" placeholder="Address line 2">
                                        </div>
                                        <div class="col-md-6 col-12 mb--20">
                                            <label>Country*</label>
                                            <select class="nice-select">
                                                <option>Bangladesh</option>
                                                <option>China</option>
                                                <option>country</option>
                                                <option>India</option>
                                                <option>Japan</option>
                                            </select>
                                        </div>
                                        <div class="col-md-6 col-12 mb--20">
                                            <label>Town/City*</label>
                                            <input type="text" placeholder="Town/City">
                                        </div>
                                        <div class="col-md-6 col-12 mb--20">
                                            <label>State*</label>
                                            <input type="text" placeholder="State">
                                        </div>
                                        <div class="col-md-6 col-12 mb--20">
                                            <label>Zip Code*</label>
                                            <input type="text" placeholder="Zip Code">
                                        </div>
                                    </div>
                                </div>
                                
                            </div>
                            <div class="col-lg-5">
                                <div class="row">
                                    <!-- Cart Total -->
                                    <div class="col-12">
                                        <div class="checkout-cart-total">
                                            <h2 class="checkout-title">YOUR ORDER</h2>
                                            <?php if(session('cart_data')): ?>
                                            <h4>Product <span>Total</span></h4>
                                            <ul>
                                                <?php
                                                    $subtotal=0;
                                                    $delivery_fee=60;
                                                ?>

                                                <?php $__currentLoopData = session('cart_data'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $each_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php $subtotal= $subtotal + ($each_product['price'] * $each_product['quantity']) ?>
                                                <li><span class="left"><?php echo e($each_product['pname'].' X '.$each_product['quantity']); ?> </span> <span
                                                        class="right"><?php echo e(isset($settings) ? $settings->currency_symbol ?? "Currency Not Set " : "Currency Not Set "); ?> <?php echo e(number_format($each_product['price'] * $each_product['quantity'],2)); ?></span></li>
                                                
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                            <p>Sub Total <span><?php echo e(isset($settings) ? $settings->currency_symbol ?? "Currency Not Set " : "Currency Not Set "); ?> <?php echo e(number_format($subtotal,2)); ?></span></p>
                                            <p>Shipping Fee <span><?php echo e(isset($settings) ? $settings->currency_symbol ?? "Currency Not Set " : "Currency Not Set "); ?> <?php echo e(number_format($delivery_charge,2)); ?></span></p>
                                            <h4>Grand Total <span><?php echo e(isset($settings) ? $settings->currency_symbol ?? "Currency Not Set " : "Currency Not Set "); ?> <?php echo e(number_format(($cart_data['grandtotal'] + $delivery_charge),2)); ?></span></h4>
                                            <?php else: ?> 
                                            <h4>Your cart is empty!</h4>
                                            <?php endif; ?>
                                            
                                            <p>
                                            <div class="method-notice mt--25">
                                                
                                                <?php $__currentLoopData = $payment_methods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $each_method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                $checked='';
                                                if($loop->index==0){$checked='checked';}   
                                                ?>
                                                <div class="custom-control custom-radio custom-control-inline">
                                                <input type="radio" <?php echo e($checked); ?> id="payment_<?php echo e($each_method->id); ?>" name="payment_method" data-payment="<?php echo e($each_method->id); ?>" value="<?php echo e($each_method->id); ?>" class="custom-control-input payment_btn">
                                                    <label class="custom-control-label form-control" for="payment_<?php echo e($each_method->id); ?>"><?php echo e($each_method->type); ?></label>
                                                </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>                                                  

                                            </div>
                                            <div class="stripe-payment-box">
                                               
                                                    <div class="form-row">
                                                        <div class="col-md-12 col-12">
                                                            <label>Name on Card</label>
                                                            <input type="text" name="card_customer_name" placeholder="Name" >
                                                        </div>
                                                      <label for="card-element">
                                                        Credit or debit card
                                                      </label>
                                                      <div id="card-element">
                                                        <!-- A Stripe Element will be inserted here. -->
                                                      </div>
                                                  
                                                      <!-- Used to display form errors. -->
                                                      <div id="card-errors" role="alert"></div>
                                                    </div>                                                  
                                           </div>
                                            

                                        </p>
                                            <div class="term-block">
                                                <input type="checkbox" checked id="accept_terms2" name="isagree" value="1">
                                                <label for="accept_terms2">I’ve read and accept the terms &
                                                    conditions</label>
                                            </div>
                                            <button type="" class="place-order w-100">Place order</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>
<!-- Cart Page Start -->

<script src="https://js.stripe.com/v3/"></script>
<script src="<?php echo e(asset('view_js/frontend/checkout.js')); ?>"></script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.frontend.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\pharmastore\resources\views/frontend/checkout.blade.php ENDPATH**/ ?>